Scriptname SuH_Status extends Quest  

;	SuH_Status is the data container for Succubus Heart. This script's one and only purpose is to store any data Succubus Heart needs across various scripts and ensure these values are initialized when the mod starts and each time the game loads. Changing these references or values (with the exception of External Script References, which are grabbed by each script independantly) will effect all of Succubus Heart.

;	External Script References
SuH_Fun property _f auto
SuH_Main property _m auto

;	MOD and SuH_Quest Holder
int property SuH_MODversion = 0 auto
int property SuH_MCMversion = 0 auto
int property SuH_MPversion = 0 auto ; Main_Player Mod Verison

;	Want to not use
spell property SuH_sex_CScd auto



;	State Checks
int property SuH_Framework = 0 auto ; Sets framework to prioritize, 0=none 1=SexLab 2=OStim Standalone (Will default to use SexLab over OStim)
int property SuH_Frame_SexLab = 0 auto ; Sets if SexLab is installed
int property SuH_Frame_OStim = 0 auto ; Sets if OStim is installed
int property SuH_PCSdraincount = 0 auto ; Drain Count for detected animation
int property SuH_MPlayertickcounter = 0 auto ; Used to show main_player on_update count for stuck script detection
int property SuH_CSanimprocessing = 0 auto ; Check if Combat Seduction is trying to process an animation, unfortunately required to prevent SexLab overlapping animations
bool property SuH_runupdates = false auto ; Whether we should run updates or not, set true after Succubus Heart initiates
int property SuH_currentgameday = 0 auto ; Current game day tracked for Realm calculations

;	PCS - Player Character Status
int property SuH_PCSgender = 0 auto ; 0 = male , 1 = female , 2 = male creature , 3 = female creature

int property SuH_PCSabsorbhealth = 1 auto ; Health Absorption Rating
int property SuH_PCSabsorbmagicka = 1 auto ; Magicka Absorption Rating
int property SuH_PCSabsorbstamina = 1 auto ; Stamina Absorption Rating

int property SuH_PCSbdsm = 0 auto ; total BDSM rating to lower get calls when all points are needed, used as an optimization
int property SuH_PCSbpoint = 0 auto ; Body rating
int property SuH_PCSdpoint = 0 auto ; Desire rating
int property SuH_PCSmpoint = 0 auto ; Mind rating
int property SuH_PCSspoint = 0 auto ; Soul rating

int property SuH_PCScaphealth = 100 auto ; total Health Cap
int property SuH_PCScaphealthdown = 0 auto ; decreased Health Cap from passives/actives
int property SuH_PCScaphealthitem = 0 auto ; increased Health Cap from items
int property SuH_PCScapmagicka = 100 auto ; " " for magicka
int property SuH_PCScapmagickadown = 0 auto
int property SuH_PCScapmagickaitem = 0 auto
int property SuH_PCScapstamina = 100 auto ; " " for stamina
int property SuH_PCScapstaminadown = 0 auto
int property SuH_PCScapstaminaitem = 0 auto
int property SuH_PCScaplevel = 0 auto ; Effective cap increase (from heart levels, base increase is hard-coded)

int property SuH_PCSxp = 200 auto ; HeartXP
int property SuH_PCSxpgain = 100 auto ; total HeartXP Gain stat, 100=100%, stored as int to avoid float accuracy issues
int property SuH_PCSxpgainitem = 0 auto ; HeartXP Gain added from items

int property SuH_PCSskillxp = 0 auto ; SkillXP

int property SuH_PCSarousal = 32000 auto ; curent player Arousal
int property SuH_PCSarousalgain = 10000 auto ; Arousal gained per in-game hour
int property SuH_PCSarousaltarget = 160000 auto ; Arousal amount for 100% (the "Target" arousal)
float property SuH_PCSarousalgainmulti = 1.0 auto ; multiplier applied when arousal is gained through _Fun.PC_addArousal
int property SuH_PCSarousalstate = 1 auto ; current arousal state, check _Fun.PC_arousalState

int property SuH_PCSsexbonus = 0 auto ; Sex bonus amount
int property SuH_PCSsexbonushour = 10000 auto ; SexBonus representing 1-hour in-game time
int property SuH_PCSsexbonusmax = 5000 auto ; Max SexBonus 'timer' that can be held
int property SuH_PCSsexbonusadd = 100 auto ; multiplier applied to Sex Bonus via _Fun.PC_addSexBonus
int property SuH_PCSfluidbonus = 0 auto ; " " for fluid
int property SuH_PCSfluidbonushour = 10000 auto
int property SuH_PCSfluidbonusmax = 5000 auto
int property SuH_PCSfluidbonusadd = 100 auto ; multiplier applied to Fluid Bonus via _Fun.PC_addFluidBonus

int property SuH_PCSfluidhealth = 1 auto ; Fluid Health Bonus
int property SuH_PCSfluidmagicka = 1 auto ; Fluid Magicka Bonus
int property SuH_PCSfluidstamina = 1 auto ; Fluid Stamina Bonus

int property SuH_PCSofferpoints = 0 auto ; Offering Points held over to determine future offering rewards
;	Player titles
int property SuH_title_succubus = 0 auto ; Succubus title state
int property SuH_titlexp_succubus = 0 auto ; Succubus title experience
int property SuH_title_drinker = 0 auto ; " "
int property SuH_titlexp_drinker = 0 auto
int property SuH_title_friendly = 0 auto ; " "
int property SuH_titlexp_friendly = 0 auto
int property SuH_title_pettrain = 0 auto ; " "
int property SuH_titlexp_pettrain = 0 auto
int property SuH_title_offeritem = 0 auto ; " "
int property SuH_titlexp_offeritem = 0 auto
int property SuH_title_seducer = 0 auto ; " "
int property SuH_titlexp_seducer = 0 auto

int property SuH_title_pethit = 0 auto ; " "
int property SuH_title_realmvisit = 0 auto ; " "
int property SuH_title_drainkilled = 0 auto ; " "
int property SuH_title_fedchest = 0 auto ; " "
int property SuH_title_statdown = 0 auto ; " "
;	Stat Mod
float property SuH_SETdisablehealthrecovery = 0.00 auto ; disable Health Recover, was a float to check for overrides which no longer function
float property SuH_SETdisablemagickarecovery = 0.00 auto ; " "
float property SuH_SETdisablestaminarecovery = 0.00 auto ; " "
;	Passives
int property SuH_SETfreepassivereset = 0 auto ; set if passive resets are free, 0=no 1=yes
int property SuH_rank_bdsm = 0 auto ; increased BDSM rating level from Passives menu, treated as a passive but does not reset
int property SuH_rank_deviouspartner = 0 auto ; Passive Ranks
int property SuH_rank_deviouspartner2 = 0 auto
int property SuH_rank_forcemaster = 0 auto
int property SuH_rank_formalbeauty = 0 auto
int property SuH_rank_formalbeauty2 = 0 auto ; Unused
int property SuH_rank_giftedconsent = 0 auto
int property SuH_rank_giftedconsentplus = 0 auto
int property SuH_rank_healthyabsorber = 0 auto
int property SuH_rank_lusciousliquids = 0 auto
int property SuH_rank_lusciousliquids2 = 0 auto
int property SuH_rank_masochist = 0 auto
int property SuH_rank_masochist2 = 0 auto
int property SuH_rank_masochist3 = 0 auto
int property SuH_rank_perfectorgasm = 0 auto
int property SuH_rank_perfectorgasm2 = 0 auto
int property SuH_rank_regalglow = 0 auto
int property SuH_rank_savingessence = 0 auto
int property SuH_rank_savingessence2 = 0 auto
int property SuH_rank_seducer = 0 auto
int property SuH_rank_seducer2 = 0 auto
int property SuH_rank_selfstacker = 0 auto
int property SuH_rank_selfstackerplus = 0 auto
int property SuH_rank_violence = 0 auto
int property SuH_rank_violence2 = 0 auto
int property SuH_rank_violence3 = 0 auto
int property SuH_rank_violenceCD = 0 auto
int property SuH_rank_capexcel = 0 auto
int property SuH_rank_capexcel2 = 0 auto
int property SuH_rank_capexcelplus = 0 auto
int property SuH_rank_soultap = 0 auto
int property SuH_rank_soultapplus = 0 auto
;	Realm
int property SuH_realm_fountainsperm = 1 auto
int property SuH_realm_fountainmilk = 1 auto
int property SuH_realm_fountainday = 0 auto
int property SuH_realm_taliboost = 200 auto ; Tali's 'blood chip' storage, each blood chip is valued at 20, so 200 = 20 blood chips
int property SuH_realm_talirepoints = 0 auto
int property SuH_realm_talitimelast = 0 auto
int property SuH_realm_talitoollvl = 1 auto
int property SuH_realm_talistorelvl = 1 auto
Form property SuH_realm_talireitem = none auto
;	Actives
int property SuH_rank_sexualentice = 1 auto ; Active ranks
int property SuH_rank_sexualenrage = 1 auto

int property SuH_SETonlyframepref = 0 auto ; Only Use Framework Pref. setting, 0=no 1=yes
int property SuH_SETdeathdrops = 1 auto ; Death Drops setting, 0=no 1=yes
int property SuH_SETcalmaura = 0 auto ; Calming Aura in act setting, 0=no 1=yes
int property SuH_SETmilkdistribute = 0 auto ; female milk drop setting, 0=no 1=yes
int property SuH_SETspermdistribute = 1 auto ; male milk drop setting, 0=no 1=yes
int property SuH_SETpreventactdeath = 1 auto ; prevent death in act setting, 0=no 1=yes

int property SuH_SETactendonatk = 0 auto ; end act when attacked setting, 0=no 1=yes
int property SuH_SETallowfemalehomo = 1 auto ; allow succubus heart to trigger female homo acts setting, 0=no 1=yes
int property SuH_SETallowmalehomo = 0 auto ; " " for male
int property SuH_SETclearactor = 0 auto ; clear arrows from player setting, 0=no 1=yes
int property SuH_SETrestrictact = 0 auto ; females use cowgirl when aggressor setting, 0=no 1=yes
int property SuH_SETslaifix = 1 auto ; sexlab ai fix setting, 0=no 1=yes

int property SuH_SETnpcabsorb = 1 auto ; drain affects npcs setting, 0=none 1=all 2=non-allies
int property SuH_SETalwaysabsorbbenefit = 0 auto ; always gain drain benefit setting, 0=no 1=yes
int property SuH_SETallowdrainkill = 1 auto ; allow drain kill setting, 0=no 1=yes , 0=Never 1=all 2=non-allies
int property SuH_SETalwaysdrainkill = 0 auto ; drain allways kills setting, 0=no 1=yes
Float property SuH_PCSeffectmulti = 1.0 auto ; HeartXP multiplier setting, 1.0=100%
int property SuH_SETdynaspid = 1 auto ; use SPID setting, 0=(Use fallback system with cloaks) 1=(Skip cloak fallback)
int property SuH_SETdrainvisualinact = 0 auto ; drain visuals in act settings, 0=no 1=yes
int property SuH_SETrealmspellcost = 1 auto ; realm spell costs magicka setting, 0=no 1=yes
int property SuH_SETcarrycorrect = 0 auto ; Correct carry weight setting
int property SuH_SETdrainresetorgasm = 0 auto ; Reset Drain on Orgasm setting 0=no 1=yes
int property SuH_SETarousaldefect = 1 auto ; Allow arousal defects to happen setting 0=no 1=yes
;	Combat Seduction
int property SuH_SETcombatseduction = 0 auto ; combat seduction, 0=disabled 1=enabled
int property SuH_SETnpc2npchealthmin = 20 auto ; npc to npc health submit min
int property SuH_SETnpc2pchealthmin = 20 auto ; npc to player health submit min
int property SuH_SETpc2npchealthmin = 20 auto ; player to npc health submit min
float property SuH_SETnpc2npchealth = 0.30 auto ; npc to npc health submit percentage
float property SuH_SETnpc2pchealth = 0.30 auto ; npc to player health submit percentage
float property SuH_SETpc2npchealth = 0.30 auto ; player to npc health submit percentage
float property SuH_SETpc2npcstamina = 0.30 auto ; player to npc stamina submit percentage
int property SuH_SETcscooldown = 10 auto ; submit cooldown setting, set in seconds
;	Soul Pets
int property SuH_SETpetremoveondeath = 1 auto ; remove pets on death setting, 0=no 1=yes
int property SuH_SETpetnewsumdismiss = 0 auto ; dismiss pets when summoning new pet setting, 0=no 1=yes
int property SuH_SETpetstayfollowing = 0 auto ; pet stays following setting, 0=no 1=yes
int property SuH_SETtraitwontkill = 0 auto ; pet traits won't kill setting, 0=no 1=yes
int property SuH_petskill = 0 auto ; player pet summoner/skill level
int property SuH_petskillxp = 0 auto ; XP for player summoner/skill
	;	Pet slot notes : Pets use a 2D array created with standard arrays, the slot number defines where we are on the y axis, x axis is defined by what array we are pulling data from
int property SuH_petactive = -1 auto ; active pet slot, mostly used as a validator
int[] property SuH_petlevels auto ; pet levels array
int[] property SuH_petxps auto ; pet xp array
string[] property SuH_petnames auto ; pet names array
Actor property SuH_actor_activepet auto ; active pet actor pulled from in-game
Actor[] property SuH_petactoralive auto ; pet actors pulled from in-game
Actor property SuH_petmostrecentactor auto ; Last pet actor to be summoned
ActorBase[] property SuH_petactorbases auto ; pet actor bases pulled from in-game
int[] property SuH_pettrait0 auto ; pet trait slot 0, for memory and pull performance reasons we limit pets to 3 traits
int[] property SuH_pettrait1 auto ; " " 1
int[] property SuH_pettrait2 auto ; " " 2
;message property SuH_menu_pettraitreset auto ; Message to reset Pet Traits in the Soul Pets MCM, Currently unused
;	Death Override Mode
int property SuH_SETspecialdeath = 0 auto ; Death Override Mode toggle, 0=disabled 1=enabled
int property SuH_CHKdied = 0 auto ; Has died and waiting for DOM respawn
int property SuH_CHKsdinact = 0 auto ; Has died and triggered an animation
int property SuH_CHKsdrespawn = 0 auto ; Has died and checking for forced respawn
int property SuH_SETcsbleedoutdelay = 5 auto ; DOM bleedout delay seting, set in seconds
int property SuH_SETneverdiemode = 0 auto ; never die mode setting, 0=disabled 1=enabled
int property SuH_SETsdlosebloodchips = 0 auto ; lose blood chips on DOM respawn setting, 0=no 1=yes
int property SuH_SETsdloseequip = 0 auto ; destroy equiped items on DOM respawn setting, 0=no 1=yes
int property SuH_SETsdloseitems = 1 auto ; lose inventory on DOM respawn setting, 0=no 1=yes
int property SuH_SETsdlosegold = 0 auto ; lose gold on DOM respawn setting, 0=no 1=yes
int property SuH_SETrandomdeathspawn = 2 auto ; force respawn after DOM respawn setting, 0=no 1=random 2=last entrance
float property SuH_SETrevivecost = 0.5 auto ; Max Status cost on DOM respawn setting, 1.0=100%
;	Keybindings
int property SuH_KEY_draintoggle = -1 auto ; keycode for drain affects NPC toggle
int property SuH_KEY_drainkilltoggle = -1 auto ; keycode for kill drain toggle
int property SuH_KEY_arousalview = -1 auto ; keycode for arousal message
int property SuH_KEY_petself = -1 auto ; keycode for pet spell
;	Mod References
faction property SuH_diedonce auto
faction property SuH_ignoreabsorb auto
faction property SuH_petfaction auto
faction property SuH_Tracker auto
faction property SuH_Vigilhostile auto
faction property SuH_Succubus auto
spell property SuH_com_absorbvisuals auto
spell property SuH_dyna_ability auto
spell property SuH_dyna_active auto
spell property SuH_dyna_calmaura auto
spell property SuH_spell_nightsembrace auto
spell property SuH_spell_pet auto
spell property SuH_spell_petself auto
spell property SuH_spell_pettarget auto
spell property SuH_spell_selfpleasure auto
spell property SuH_spell_sexualenrage auto
spell property SuH_spell_sexualentice auto
spell property SuH_spell_teliRealm auto
spell property SuH_spell_pTraitHealth auto
spell property SuH_spell_pTraitMagicka auto
spell property SuH_spell_pTraitStamina auto
spell property SuH_spell_pTraitHealthDown auto
spell property SuH_spell_pTraitMagickaDown auto
spell property SuH_spell_pTraitStaminaDown auto
spell property SuH_dyna_SPID auto
spell property SuH_arousal_0 auto
spell property SuH_arousal_1 auto
spell property SuH_arousal_2 auto
spell property SuH_arousal_3 auto
spell property SuH_arousal_4 auto
spell property SuH_spell_remotechest auto

potion property SuH_alch_sperm auto
potion property SuH_alch_spermcreature auto
potion property SuH_alch_spermsuccubus auto
potion property SuH_alch_sperm25 auto
potion property SuH_alch_spermcreature25 auto

potion property SuH_alch_milk auto
potion property SuH_alch_milkcreature auto
potion property SuH_alch_milksuccubus auto
potion property SuH_alch_milk20 auto
potion property SuH_alch_milkcreature20 auto

Potion property SuH_alch_empowermentstone auto
Potion property SuH_alch_refreshstone auto
Potion property SuH_alch_soulofdesire auto
Potion property SuH_alch_soulofexperience auto
Potion property SuH_alch_soulofforce auto
Potion property SuH_alch_souloflife auto
Potion property SuH_alch_soulofmagic auto
Potion property SuH_alch_soulofpower auto
Potion property SuH_alch_soulofexperience25 auto
Potion property SuH_alch_soulofforce25 auto
Potion property SuH_alch_souloflife25 auto
Potion property SuH_alch_soulofmagic25 auto
Potion property SuH_alch_soulofpower25 auto
Potion property SuH_alch_specialtystone auto
Potion property SuH_alch_vitalitystone auto

ObjectReference property SuH_sd_lostchest auto
ObjectReference property SuH_sd_goldchest auto
ObjectReference property SuH_cont_repchest auto
ObjectReference property SuH_sevaspawn auto 
ObjectReference property SuH_sd_portalpoint auto 
ObjectReference property SuH_sd_returnpointcell auto 
ObjectReference property SuH_sd_returnpoint auto 
ObjectReference property SuH_sd_spawn1 auto 
ObjectReference property SuH_sd_spawn2 auto 
ObjectReference property SuH_sd_spawn3 auto 
ObjectReference property SuH_sd_spawn4 auto 
ObjectReference property SuH_sd_spawn5 auto 
ObjectReference property SuH_sd_spawn6 auto 
ObjectReference property SuH_sd_spawn7 auto 
ObjectReference property SuH_sd_spawn8 auto
ObjectReference property SuH_realm_petinitspawn auto
Actor property playerRef auto
Actor property SuH_actor_tali auto
ActorBase property playerBase auto
Armor property SuH_armor_regalglow auto
MiscObject property SuH_misc_bloodchip auto
Keyword property SuH_key_inccapall auto
Keyword property SuH_key_inccaphealth auto
Keyword property SuH_key_inccapmagicka auto
Keyword property SuH_key_inccapstamina auto
Keyword property SuH_key_incforce auto
Keyword property SuH_key_incxp auto
Keyword property SuH_key_inccaphealth25 auto
Keyword property SuH_key_inccapmagicka25 auto
Keyword property SuH_key_inccapstamina25 auto
Keyword property SuH_key_incforce25 auto
Keyword property SuH_key_incxp25 auto
Keyword property SuH_key_incdesire auto
Keyword property SuH_key_incsp auto
Keyword property SuH_key_incxpgain auto
Keyword property SuH_key_milk auto
Keyword property SuH_key_milk20 auto
Keyword property SuH_key_pet auto
Keyword property SuH_key_petdog auto
Keyword property SuH_key_petskeever auto
Keyword property SuH_key_petdraugr auto
Keyword property SuH_key_pethusky auto
Keyword property SuH_key_petriekling auto
Keyword property SuH_key_resetpassives auto
Keyword property SuH_key_sperm auto
Keyword property SuH_key_sperm25 auto
Keyword property SuH_key_stat auto
Keyword property SuH_keyword auto
Message property SuH_menu_petself auto
Message property SuH_menu_pettarget auto
Message property SuH_menu_teliworld auto
Message property SuH_menu_remotechest auto
;Message property SuH_menu_hxprefund auto ; unused
Message property SuH_menu_telirealm auto
Message property SuH_menu_realmfountain auto
Message property SuH_menu_offer auto
Message property SuH_menu_realmtalibench auto
Message property SuH_menu_csaccept auto
Message property SuH_menu_csreceive auto
Message property SuH_menu_lustfultake auto
Cell property SuH_realm auto
Worldspace property SuH_worldspace auto
ObjectReference property SuH_cont_bloodchest auto
ObjectReference property SuH_cont_keeperchest auto
ObjectReference property SuH_cont_keeperchest1 auto
;	SexLab References
SexLabFramework property SexLab auto
package property SexLabDoNothing auto
;	Base Game References
faction property CurrentFollowerFaction auto
faction property PlayerPotentialAnimalFaction auto
faction property PotentialFollowerFaction auto
faction property PlayerFaction auto
MiscObject property Gold001 auto
DialogueFollowerScript Property DialogueFollower Auto
Quest Property pDialogueFollower  Auto
spell property SuH_spell_SoulTrap Auto


;	Set Properties
	;	This funciton grabs references using FormIDs, updating these with an external mod or replacing the FormID will replace it through-out all of Succubus Heart
	;	initquests : bool : If we should run the initialization script on other scripts to start Succubus Heart
Function InitProperties(bool initquests=false)
	;	Figure out the current framework running, do this check every time in-case of a mid-game switch
	if Game.IsPluginInstalled("SexLab.esm") ; If SexLab, grab related packages
		SexLab = Game.GetFormFromFile(0xD62, "SexLab.esm") as SexLabFramework
		SexLabDoNothing = Game.GetFormFromFile(0x00E50E, "Sexlab.esm") as package
		
		if SuH_Framework == 0 ; If priority is not set
			SuH_framework = 1 ; Set SexLab as Priority
			SuH_Frame_SexLab = 2  ; Set SexLab Installed and using
		else
			if SuH_SETonlyframepref > 0 && SuH_framework != 1
				SuH_Frame_SexLab = 1 ; Set SexLab Installed but not used
			else
				SuH_Frame_SexLab = 2 ; Set SexLab Installed and using
			endIf
		endIf
	else ; if SexLab is not found, set not installed and reset priority if it was set
		SuH_Frame_SexLab = 0
		if SuH_Framework == 1
			SuH_Framework = 0
		endIf
	endIf
	if  Game.IsPluginInstalled("OStim.esp") ; If OStim found (Use OStim global functions)
		debug.messagebox("< Succubus Heart >\nOStim.esp Detected!\nOStim support is only partial and in development, features may not function as inteded when OStim is used.")
		if SuH_Framework == 0 ; If no priority (and if SexLab not found) set OStim as priority
			SuH_Framework = 2
			SuH_Frame_OStim = 2
		else
			if SuH_SETonlyframepref > 0 && SuH_framework != 2
				SuH_Frame_OStim = 1
			else
				SuH_Frame_OStim = 2
			endIf
		endIf
	else
		SuH_Frame_OStim = 0
		if SuH_Framework == 2
			if SuH_Frame_SexLab > 1
				SuH_Framework = 1
				SuH_Frame_SexLab = 2
			else
				SuH_Framework = 0
			endIf
		endIf
	endIf
	if SuH_Framework == 0 ; if no framework was found or set as priority
		debug.messagebox("< Succubus Heart >\nInitialization Failed!\nSexLab wasn't detected and Succubus Heart won't work as intended! This means either something wasn't installed properly or this version of SexLab isn't compatible with Succubus Heart!\nIf you're having trouble you can contact us on Discord for help!")
	endIf
	
	playerRef = Game.GetFormFromFile(0x14, "Skyrim.esm") as Actor
	playerBase = Game.GetFormFromFile(0x7, "Skyrim.esm") as ActorBase
	Gold001 = Game.GetFormFromFile(0xF, "Skyrim.esm") as MiscObject
	pDialogueFollower = Game.GetFormFromFile(0x750BA, "Skyrim.esm") as Quest
	DialogueFollower = Game.GetFormFromFile(0x750BA, "Skyrim.esm") as DialogueFollowerScript
	
	_f = Game.GetFormFromFile(0x814, "Succubus Heart.esp") as SuH_Fun
	_m = Game.GetFormFromFile(0x801, "Succubus Heart.esp") as SuH_Main
	
	SuH_actor_tali = Game.GetFormFromFile(0x2060F, "Succubus Heart.esp") as actor
	
	SuH_key_petdog = Game.GetFormFromFile(0x2C2369, "Succubus Heart.esp") as Keyword
	SuH_key_petskeever = Game.GetFormFromFile(0x2C236C, "Succubus Heart.esp") as Keyword
	SuH_key_petdraugr = Game.GetFormFromFile(0x2C236D, "Succubus Heart.esp") as Keyword
	SuH_key_pethusky = Game.GetFormFromFile(0x2C2375, "Succubus Heart.esp") as Keyword
	SuH_key_petriekling = Game.GetFormFromFile(0x2C2371, "Succubus Heart.esp") as Keyword
	
	SuH_alch_soulofpower = Game.GetFormFromFile(0x2C2363, "Succubus Heart.esp") as Potion
	SuH_alch_soulofpower25 = Game.GetFormFromFile(0x2C2365, "Succubus Heart.esp") as Potion
	SuH_alch_soulofmagic = Game.GetFormFromFile(0x2C235F, "Succubus Heart.esp") as Potion
	SuH_alch_soulofmagic25 = Game.GetFormFromFile(0x2C2361, "Succubus Heart.esp") as Potion
	SuH_alch_souloflife = Game.GetFormFromFile(0x2C235B, "Succubus Heart.esp") as Potion
	SuH_alch_souloflife25 = Game.GetFormFromFile(0x2C235D, "Succubus Heart.esp") as Potion
	SuH_alch_soulofforce = Game.GetFormFromFile(0x2C2357, "Succubus Heart.esp") as Potion
	SuH_alch_soulofforce25 = Game.GetFormFromFile(0x2C2359, "Succubus Heart.esp") as Potion
	SuH_alch_soulofexperience = Game.GetFormFromFile(0x2C2353, "Succubus Heart.esp") as Potion
	SuH_alch_soulofexperience25 = Game.GetFormFromFile(0x2C2355, "Succubus Heart.esp") as Potion
	
	SuH_alch_refreshstone = Game.GetFormFromFile(0x2C2350, "Succubus Heart.esp") as Potion
	SuH_alch_empowermentstone = Game.GetFormFromFile(0x2C234F, "Succubus Heart.esp") as Potion
	SuH_alch_specialtystone = Game.GetFormFromFile(0x2C234C, "Succubus Heart.esp") as Potion
	SuH_alch_vitalitystone = Game.GetFormFromFile(0x2C234A, "Succubus Heart.esp") as Potion
	SuH_alch_soulofdesire = Game.GetFormFromFile(0x2C2349, "Succubus Heart.esp") as Potion
	
	SuH_alch_sperm = Game.GetFormFromFile(0x2BD218, "Succubus Heart.esp") as Potion
	SuH_alch_spermcreature = Game.GetFormFromFile(0x2BD219, "Succubus Heart.esp") as Potion
	SuH_alch_spermsuccubus = Game.GetFormFromFile(0x2BD21B, "Succubus Heart.esp") as Potion
	SuH_alch_sperm25 = Game.GetFormFromFile(0x2BD21C, "Succubus Heart.esp") as Potion
	SuH_alch_spermcreature25 = Game.GetFormFromFile(0x2BD21D, "Succubus Heart.esp") as Potion
	
	SuH_alch_milk = Game.GetFormFromFile(0x2BD21E, "Succubus Heart.esp") as Potion
	SuH_alch_milkcreature = Game.GetFormFromFile(0x2BD229, "Succubus Heart.esp") as Potion
	SuH_alch_milksuccubus = Game.GetFormFromFile(0x2BD21F, "Succubus Heart.esp") as Potion
	SuH_alch_milk20 = Game.GetFormFromFile(0x2BD221, "Succubus Heart.esp") as Potion
	SuH_alch_milkcreature20 = Game.GetFormFromFile(0x2BD222, "Succubus Heart.esp") as Potion
	
	SuH_misc_bloodchip = Game.GetFormFromFile(0x164246, "Succubus Heart.esp") as MiscObject
	
	SuH_com_absorbvisuals = Game.GetFormFromFile(0x6B7ED, "Succubus Heart.esp") as Spell
	SuH_dyna_ability = Game.GetFormFromFile(0xD99, "Succubus Heart.esp") as Spell
	SuH_dyna_active = Game.GetFormFromFile(0xD9F, "Succubus Heart.esp") as Spell
	SuH_dyna_calmaura = Game.GetFormFromFile(0xF4884, "Succubus Heart.esp") as Spell
	SuH_dyna_SPID = Game.GetFormFromFile(0x201685, "Succubus Heart.esp") as Spell
	SuH_sex_CScd = Game.GetFormFromFile(0x5C46E, "Succubus Heart.esp") as Spell
	SuH_spell_nightsembrace = Game.GetFormFromFile(0x9A1A, "Succubus Heart.esp") as Spell
	SuH_spell_pet = Game.GetFormFromFile(0x187A52, "Succubus Heart.esp") as Spell
	SuH_spell_petself = Game.GetFormFromFile(0x8A00B, "Succubus Heart.esp") as Spell
	SuH_spell_pettarget = Game.GetFormFromFile(0x8F137, "Succubus Heart.esp") as Spell
	SuH_spell_selfpleasure = Game.GetFormFromFile(0x8487, "Succubus Heart.esp") as Spell
	SuH_spell_sexualenrage = Game.GetFormFromFile(0x1869, "Succubus Heart.esp") as Spell
	SuH_spell_sexualentice = Game.GetFormFromFile(0x8484, "Succubus Heart.esp") as Spell
	SuH_spell_teliRealm = Game.GetFormFromFile(0xF0A7, "Succubus Heart.esp") as Spell
	SuH_arousal_0 = Game.GetFormFromFile(0x2109F8, "Succubus Heart.esp") as Spell
	SuH_arousal_1 = Game.GetFormFromFile(0x2109FA, "Succubus Heart.esp") as Spell
	SuH_arousal_2 = Game.GetFormFromFile(0x2109FC, "Succubus Heart.esp") as Spell
	SuH_arousal_3 = Game.GetFormFromFile(0x2109FE, "Succubus Heart.esp") as Spell
	SuH_arousal_4 = Game.GetFormFromFile(0x210A00, "Succubus Heart.esp") as Spell
	SuH_spell_pTraitHealth = Game.GetFormFromFile(0x26BEA7, "Succubus Heart.esp") as Spell
	SuH_spell_pTraitMagicka = Game.GetFormFromFile(0x26BEA9, "Succubus Heart.esp") as Spell
	SuH_spell_pTraitStamina = Game.GetFormFromFile(0x26BEAB, "Succubus Heart.esp") as Spell
	SuH_spell_pTraitHealthDown = Game.GetFormFromFile(0x26BEAD, "Succubus Heart.esp") as Spell
	SuH_spell_pTraitMagickaDown = Game.GetFormFromFile(0x26BEB2, "Succubus Heart.esp") as Spell
	SuH_spell_pTraitStaminaDown = Game.GetFormFromFile(0x26BEB4, "Succubus Heart.esp") as Spell
	SuH_spell_remotechest = Game.GetFormFromFile(0x164247, "Succubus Heart.esp") as Spell
	SuH_spell_SoulTrap = Game.GetFormFromFile(0x2948EA, "Succubus Heart.esp") as Spell
	
	CurrentFollowerFaction = Game.GetFormFromFile(0x5C84E, "Skyrim.esm") as faction
	SuH_diedonce = Game.GetFormFromFile(0x1DDE6D, "Skyrim.esm") as faction
	PlayerFaction = Game.GetFormFromFile(0xDB1, "Skyrim.esm") as faction
	PlayerPotentialAnimalFaction = Game.GetFormFromFile(0x9A7B2, "Skyrim.esm") as faction
	PotentialFollowerFaction = Game.GetFormFromFile(0x5C84D, "Skyrim.esm") as faction
	SuH_ignoreabsorb = Game.GetFormFromFile(0xDAC3, "Succubus Heart.esp") as faction
	SuH_petfaction = Game.GetFormFromFile(0x10633, "Succubus Heart.esp") as faction
	SuH_Tracker = Game.GetFormFromFile(0x804, "Succubus Heart.esp") as faction
	SuH_Vigilhostile = Game.GetFormFromFile(0x1D8D47, "Succubus Heart.esp") as faction
	SuH_Succubus = Game.GetFormFromFile(0x26bfac, "Succubus Heart.esp") as faction
	
	SuH_sd_lostchest = Game.GetFormFromFile(0xE5CA, "Succubus Heart.esp") as ObjectReference
	SuH_sd_goldchest = Game.GetFormFromFile(0x1680C, "Succubus Heart.esp") as ObjectReference
	SuH_cont_bloodchest = Game.GetFormFromFile(0x1E8124, "Succubus Heart.esp") as ObjectReference
	SuH_cont_keeperchest = Game.GetFormFromFile(0x1E2FA2, "Succubus Heart.esp") as ObjectReference
	SuH_cont_keeperchest1 = Game.GetFormFromFile(0x1E2FA6, "Succubus Heart.esp") as ObjectReference
	SuH_cont_repchest = Game.GetFormFromFile(0x23E523, "Succubus Heart.esp") as ObjectReference
	
		; Old spawn for old realm interier, still functional but unused
	;SuH_sevaspawn = Game.GetFormFromFile(0x20E72, "Succubus Heart.esp") as ObjectReference
	SuH_sevaspawn = Game.GetFormFromFile(0x1C99D9, "Succubus Heart.esp") as ObjectReference
	SuH_sd_portalpoint = Game.GetFormFromFile(0xE5C7, "Succubus Heart.esp") as ObjectReference
	SuH_sd_returnpoint = Game.GetFormFromFile(0xF0A6, "Succubus Heart.esp") as ObjectReference
	SuH_sd_returnpointcell = Game.GetFormFromFile(0x84ED2, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn1 = Game.GetFormFromFile(0x1CEC8, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn2 = Game.GetFormFromFile(0x1D433, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn3 = Game.GetFormFromFile(0x1D434, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn4 = Game.GetFormFromFile(0x1D44B, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn5 = Game.GetFormFromFile(0x1D44F, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn6 = Game.GetFormFromFile(0x1D451, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn7 = Game.GetFormFromFile(0x1D453, "Succubus Heart.esp") as ObjectReference
	SuH_sd_spawn8 = Game.GetFormFromFile(0x1D454, "Succubus Heart.esp") as ObjectReference
	
	SuH_realm_petinitspawn = Game.GetFormFromFile(0x18292B, "Succubus Heart.esp") as ObjectReference
	
	SuH_armor_regalglow = Game.GetFormFromFile(0x1AE79, "Succubus Heart.esp") as Armor
	
	SuH_key_inccapall = Game.GetFormFromFile(0x1DDE7B, "Succubus Heart.esp") as Keyword
	SuH_key_inccaphealth = Game.GetFormFromFile(0x1DDE76, "Succubus Heart.esp") as Keyword
	SuH_key_inccapmagicka = Game.GetFormFromFile(0x1DDE77, "Succubus Heart.esp") as Keyword
	SuH_key_inccapstamina = Game.GetFormFromFile(0x1DDE7A, "Succubus Heart.esp") as Keyword
	SuH_key_incforce = Game.GetFormFromFile(0x1DDE75, "Succubus Heart.esp") as Keyword
	SuH_key_incxp = Game.GetFormFromFile(0x1DDE73, "Succubus Heart.esp") as Keyword
	
	SuH_key_inccaphealth25 = Game.GetFormFromFile(0x20B970, "Succubus Heart.esp") as Keyword
	SuH_key_inccapmagicka25 = Game.GetFormFromFile(0x20B973, "Succubus Heart.esp") as Keyword
	SuH_key_inccapstamina25 = Game.GetFormFromFile(0x20B974, "Succubus Heart.esp") as Keyword
	SuH_key_incforce25 = Game.GetFormFromFile(0x20B96F, "Succubus Heart.esp") as Keyword
	SuH_key_incxp25 = Game.GetFormFromFile(0x20B96C, "Succubus Heart.esp") as Keyword
	
	SuH_key_incdesire = Game.GetFormFromFile(0x1DDE74, "Succubus Heart.esp") as Keyword
	SuH_key_incsp = Game.GetFormFromFile(0x1DDE78, "Succubus Heart.esp") as Keyword
	SuH_key_incxpgain = Game.GetFormFromFile(0x1DDE71, "Succubus Heart.esp") as Keyword
	SuH_key_milk = Game.GetFormFromFile(0x1DDE72, "Succubus Heart.esp") as Keyword
	SuH_key_milk20 = Game.GetFormFromFile(0x1F23A1, "Succubus Heart.esp") as Keyword
	SuH_key_pet = Game.GetFormFromFile(0x1AB262, "Succubus Heart.esp") as Keyword
	SuH_key_resetpassives = Game.GetFormFromFile(0x1DDE70, "Succubus Heart.esp") as Keyword
	SuH_key_sperm = Game.GetFormFromFile(0x1DDE79, "Succubus Heart.esp") as Keyword
	SuH_key_sperm25 = Game.GetFormFromFile(0x1F23A0, "Succubus Heart.esp") as Keyword
	SuH_key_stat = Game.GetFormFromFile(0x1AB263, "Succubus Heart.esp") as Keyword
	SuH_keyword = Game.GetFormFromFile(0x1A1010, "Succubus Heart.esp") as Keyword
	
	SuH_menu_petself = Game.GetFormFromFile(0x8A00D, "Succubus Heart.esp") as Message
	SuH_menu_pettarget = Game.GetFormFromFile(0x8F135, "Succubus Heart.esp") as Message
	SuH_menu_teliworld = Game.GetFormFromFile(0x84ED3, "Succubus Heart.esp") as Message
	SuH_menu_remotechest = Game.GetFormFromFile(0x20171F, "Succubus Heart.esp") as Message
	;SuH_menu_hxprefund = Game.GetFormFromFile(0x1316CE, "Succubus Heart.esp") as Message
	SuH_menu_telirealm = Game.GetFormFromFile(0x2342A8, "Succubus Heart.esp") as Message
	SuH_menu_realmfountain = Game.GetFormFromFile(0x243649, "Succubus Heart.esp") as Message
	SuH_menu_offer = Game.GetFormFromFile(0x2529E4, "Succubus Heart.esp") as Message
	SuH_menu_realmtalibench = Game.GetFormFromFile(0x2342A7, "Succubus Heart.esp") as Message
	SuH_menu_csaccept = Game.GetFormFromFile(0x299A12, "Succubus Heart.esp") as Message
	SuH_menu_csreceive = Game.GetFormFromFile(0x29EB38, "Succubus Heart.esp") as Message
	SuH_menu_lustfultake = Game.GetFormFromFile(0x29EB39, "Succubus Heart.esp") as Message
	
	SuH_realm = Game.GetFormFromFile(0xE588, "Succubus Heart.esp") as Cell
	SuH_worldspace = Game.GetFormFromFile(0x205C0, "Succubus Heart.esp") as Worldspace
	
	if initquests == true
		_f.Start()
		_m.Start()
		_m.MODupdate()
		SuH_runupdates = true
	endIf
endFunction

Event OnInit()
	InitProperties(false)
endEvent
